(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     12754,        413]*)
(*NotebookOutlinePosition[     13597,        440]*)
(*  CellTagsIndexPosition[     13553,        436]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    \( (*\ Example\ 6.3  .1 : \ Error\ analysis\ with\ n = 
        4\ *) \n\(k[x_, \ s_] := \ Exp[x\ s];\)\), "\n", 
    \(\(f[x_] := \ 1 - \ \((Exp[x] - 1)\)/\((2\ x)\);\)\), "\n", 
    \(\(x1 = 0.0694318442;\)\), "\n", 
    \(\(x2 = 0.3300094782;\)\), "\n", 
    \(\(x3 = 0.6699905218;\)\), "\n", 
    \(\(x4 = 0.9305681558;\)\), "\n", 
    \(\(A1 = 0.1739274226;\)\), "\n", 
    \(\(A2 = 0.3260725774;\)\), "\n", 
    \(\(A3 = 0.3260725774;\)\), "\n", 
    \(\(A4 = 0.1739274226;\)\), "\n", 
    \(\(\[Lambda] = 0.5;\)\)}], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(m = {{1 - A1*\[Lambda]*k[x1, x1], \(-A2\)*\[Lambda]*k[x1, x2], \ 
            \(-A3\)*\[Lambda]*k[x1, x3], \ \(-A4\)*\[Lambda]*k[x1, x4]\ }, \n
          \t\t{\(-A1\)*\[Lambda]*k[x2, x1], \ 1 - A2*\[Lambda]*k[x2, x2], \n
            \t\t\(-A3\)*\[Lambda]*k[x2, x3], \ \(-A4\)*\[Lambda]*k[x2, x4]}, 
          \n{\(-A1\)*\[Lambda]*k[x3, x1], \ \(-A2\)*\[Lambda]*k[x3, x2], 
            1 - A3*\[Lambda]*k[x3, x3], \ \(-A4\)*\[Lambda]*k[x3, x4]}, 
          \n{\(-A1\)*\[Lambda]*k[x4, x1], \ \(-A2\)*\[Lambda]*k[x4, x2], 
            \(-A3\)*\[Lambda]*k[x4, x3], \ 1 - A4*\[Lambda]*k[x4, x4]}} // N
        \)], "Input"],

Cell[BoxData[
    \({{0.912616043552794842`, \(-0.166815093220536558`\), 
        \(-0.170799692946342451`\), \(-0.0927680213938688069`\)}, {
        \(-0.0889793292216503139`\), 0.818205112135364842`, 
        \(-0.203379975233379584`\), \(-0.11822472136058899`\)}, {
        \(-0.0911047185013257276`\), \(-0.203379975233379584`\), 
        0.74459255196944003`, \(-0.162221512834735515`\)}, {
        \(-0.0927680213938688069`\), \(-0.221643252284036851`\), 
        \(-0.304126778911684958`\), 0.793262884500333065`}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MatrixForm[%]\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"0.912616043552794842`", \(-0.166815093220536558`\), 
              \(-0.170799692946342451`\), \(-0.0927680213938688069`\)},
            {\(-0.0889793292216503139`\), "0.818205112135364842`", 
              \(-0.203379975233379584`\), \(-0.11822472136058899`\)},
            {\(-0.0911047185013257276`\), \(-0.203379975233379584`\), 
              "0.74459255196944003`", \(-0.162221512834735515`\)},
            {\(-0.0927680213938688069`\), \(-0.221643252284036851`\), 
              \(-0.304126778911684958`\), "0.793262884500333065`"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(d = Det[m]\)], "Input"],

Cell[BoxData[
    \(0.305786419340583304`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(f[x1] // N\)], "Input"],

Cell[BoxData[
    \(0.48223323599206207`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(f[x2] // N\)], "Input"],

Cell[BoxData[
    \(0.407621086320096814`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(f[x3] // N\)], "Input"],

Cell[BoxData[
    \(0.287886345385948061`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(f[x4] // N\)], "Input"],

Cell[BoxData[
    \(0.17472483166191111`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(d1 = 
      Det[\n\t\t{{0.48223323599206207`, \(-0.166815093220536558`\), 
            \(-0.170799692946342451`\), \(-0.0927680213938688069`\)}, {
            0.407621086320096814`, 0.818205112135364842`, 
            \(-0.203379975233379584`\), \(-0.11822472136058899`\)}, {
            0.287886345385948061`, \(-0.203379975233379584`\), 
            0.74459255196944003`, \(-0.162221512834735515`\)}, {
            0.17472483166191111`, \(-0.221643252284036851`\), 
            \(-0.304126778911684958`\), 0.793262884500333065`}}]\)], "Input"],

Cell[BoxData[
    \(0.305786419313504609`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(d2 = 
      Det[\n\t\t{{0.912616043552794842`, 0.48223323599206207`, 
            \(-0.170799692946342451`\), \(-0.0927680213938688069`\)}, {
            \(-0.0889793292216503139`\), 0.407621086320096814`, 
            \(-0.203379975233379584`\), \(-0.11822472136058899`\)}, {
            \(-0.0911047185013257276`\), 0.287886345385948061`, 
            0.74459255196944003`, \(-0.162221512834735515`\)}, {
            \(-0.0927680213938688069`\), 0.17472483166191111`, 
            \(-0.304126778911684958`\), 0.793262884500333065`}}]\)], "Input"],

Cell[BoxData[
    \(0.305786419308417745`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(d3 = 
      Det[\n\t\t{{0.912616043552794842`, \(-0.166815093220536558`\), 
            0.48223323599206207`, \(-0.0927680213938688069`\)}, {
            \(-0.0889793292216503139`\), 0.818205112135364842`, 
            0.407621086320096814`, \(-0.11822472136058899`\)}, {
            \(-0.0911047185013257276`\), \(-0.203379975233379584`\), 
            0.287886345385948061`, \(-0.162221512834735515`\)}, {
            \(-0.0927680213938688069`\), \(-0.221643252284036851`\), 
            0.17472483166191111`, 0.793262884500333065`}}]\)], "Input"],

Cell[BoxData[
    \(0.305786419295393674`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(d4 = 
      Det[\n\t\t{{0.912616043552794842`, \(-0.166815093220536558`\), 
            \(-0.170799692946342451`\), 0.48223323599206207`}, {
            \(-0.0889793292216503139`\), 0.818205112135364842`, 
            \(-0.203379975233379584`\), 0.407621086320096814`}, {
            \(-0.0911047185013257276`\), \(-0.203379975233379584`\), 
            0.74459255196944003`, 0.287886345385948061`}, {
            \(-0.0927680213938688069`\), \(-0.221643252284036851`\), 
            \(-0.304126778911684958`\), 0.17472483166191111`}}]\)], "Input"],

Cell[BoxData[
    \(0.305786419215184901`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[CurlyPhi]1tilde = d1/d\)], "Input"],

Cell[BoxData[
    \(0.999999999911445591`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[CurlyPhi]2tilde = d2/d\)], "Input"],

Cell[BoxData[
    \(0.999999999894810542`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[CurlyPhi]3tilde = d3/d\)], "Input"],

Cell[BoxData[
    \(0.999999999852218302`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[CurlyPhi]4tilde = d4/d\)], "Input"],

Cell[BoxData[
    \(0.999999999589915056`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ The\ approximate\ solution\ is\ \[CurlyPhi]tilde, \ 
      given\ by\ *) \n
    \[CurlyPhi]tilde = 
      0.25\ *\ \((
            Exp[x1\ x]*d1/d + Exp[x2\ x]*d2/d + \ Exp[x3\ x]*d3/d + \ 
              Exp[x4\ x]*d4/d)\)\  + f[x]\)\)], "Input"],

Cell[BoxData[
    RowBox[{"1", "+", 
      RowBox[{
        StyleBox["0.25`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2], " ", 
        RowBox[{"(", 
          RowBox[{
            RowBox[{"0.999999999911445591`", " ", 
              SuperscriptBox["E", 
                RowBox[{
                  StyleBox["0.0694318441999999969`",
                    StyleBoxAutoDelete->True,
                    PrintPrecision->9], " ", "x"}]]}], "+", 
            RowBox[{"0.999999999894810542`", " ", 
              SuperscriptBox["E", 
                RowBox[{
                  StyleBox["0.330009478199999994`",
                    StyleBoxAutoDelete->True,
                    PrintPrecision->10], " ", "x"}]]}], "+", 
            RowBox[{"0.999999999852218302`", " ", 
              SuperscriptBox["E", 
                RowBox[{
                  StyleBox["0.66999052179999996`",
                    StyleBoxAutoDelete->True,
                    PrintPrecision->10], " ", "x"}]]}], "+", 
            RowBox[{"0.999999999589915056`", " ", 
              SuperscriptBox["E", 
                RowBox[{
                  StyleBox["0.930568155799999985`",
                    StyleBoxAutoDelete->True,
                    PrintPrecision->10], " ", "x"}]]}]}], ")"}]}], "-", 
      \(\(\(-1\) + E\^x\)\/\(2\ x\)\)}]], "Output"]
}, Open  ]],

Cell[BoxData[
    RowBox[{\(\[CurlyPhi][x_]\), ":=", 
      RowBox[{"1", "+", 
        RowBox[{
          StyleBox["0.25`",
            StyleBoxAutoDelete->True,
            PrintPrecision->2], " ", 
          RowBox[{"(", 
            RowBox[{
              RowBox[{"0.999999999911445591`", " ", 
                SuperscriptBox["E", 
                  RowBox[{
                    StyleBox["0.0694318441999999969`",
                      StyleBoxAutoDelete->True,
                      PrintPrecision->9], " ", "x"}]]}], "+", 
              RowBox[{"0.999999999894810542`", " ", 
                SuperscriptBox["E", 
                  RowBox[{
                    StyleBox["0.330009478199999994`",
                      StyleBoxAutoDelete->True,
                      PrintPrecision->10], " ", "x"}]]}], "+", 
              RowBox[{"0.999999999852218302`", " ", 
                SuperscriptBox["E", 
                  RowBox[{
                    StyleBox["0.66999052179999996`",
                      StyleBoxAutoDelete->True,
                      PrintPrecision->10], " ", "x"}]]}], "+", 
              RowBox[{"0.999999999589915056`", " ", 
                SuperscriptBox["E", 
                  RowBox[{
                    StyleBox["0.930568155799999985`",
                      StyleBoxAutoDelete->True,
                      PrintPrecision->10], " ", "x"}]]}]}], ")"}]}], "-", 
        \(\(\(-1\) + E\^x\)\/\(2\ x\)\)}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Limit[\[CurlyPhi][x], \ x -> 0]\)], "Input"],

Cell[BoxData[
    \(0.999943630649263504`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \( (*\ 
      Exact\ solution\ is\ \[Phi][x] = 
        \(1. \ So\ the\ error\ is\n\t\[Phi][x]\  - \ \[CurlyPhi][x] = 
          \(1 - 999944 = \(0.000056\ at\ x = 0\)\)\), \ 
      same\ as\ in\ error1 . nb\ *) \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[CurlyPhi][x1]\)], "Input"],

Cell[BoxData[
    \(0.99994112593929767`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[CurlyPhi][x2]\)], "Input"],

Cell[BoxData[
    \(0.999928890097473654`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[CurlyPhi][x3]\)], "Input"],

Cell[BoxData[
    \(0.999880432455322676`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[CurlyPhi][x4]\)], "Input"],

Cell[BoxData[
    \(0.999757161724263454`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[CurlyPhi][1]\)], "Input"],

Cell[BoxData[
    \(0.999698836105151578`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \( (*\ So\ the\ error\ at\ x = 1\ is\ 0.000301\ \ *) \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\((m[\([1, 1]\)] - m[\([1, 2]\)] + m[\([1, 3]\)] - m[\([1, 4]\)])\)/d
      \)], "Input"],

Cell[BoxData[
    \(3.27483302685690658`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \( (*\ So\ we\ take\ B = 3.3\ \ *) \)], "Input"]
},
FrontEndVersion->"4.0 for Macintosh",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{520, 509},
WindowMargins->{{Automatic, 58}, {Automatic, 8}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1717, 49, 551, 12, 203, "Input"],

Cell[CellGroupData[{
Cell[2293, 65, 638, 9, 155, "Input"],
Cell[2934, 76, 535, 8, 71, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3506, 89, 46, 1, 27, "Input"],
Cell[3555, 92, 667, 12, 73, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4259, 109, 43, 1, 27, "Input"],
Cell[4305, 112, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4397, 118, 43, 1, 27, "Input"],
Cell[4443, 121, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4534, 127, 43, 1, 27, "Input"],
Cell[4580, 130, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4672, 136, 43, 1, 27, "Input"],
Cell[4718, 139, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4810, 145, 43, 1, 27, "Input"],
Cell[4856, 148, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4947, 154, 565, 9, 155, "Input"],
Cell[5515, 165, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5607, 171, 568, 9, 155, "Input"],
Cell[6178, 182, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6270, 188, 569, 9, 155, "Input"],
Cell[6842, 199, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6934, 205, 568, 9, 155, "Input"],
Cell[7505, 216, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7597, 222, 57, 1, 27, "Input"],
Cell[7657, 225, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7749, 231, 57, 1, 27, "Input"],
Cell[7809, 234, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7901, 240, 57, 1, 27, "Input"],
Cell[7961, 243, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8053, 249, 57, 1, 27, "Input"],
Cell[8113, 252, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8205, 258, 273, 6, 75, "Input"],
Cell[8481, 266, 1336, 32, 77, "Output"]
}, Open  ]],
Cell[9832, 301, 1441, 33, 137, "Input"],

Cell[CellGroupData[{
Cell[11298, 338, 64, 1, 27, "Input"],
Cell[11365, 341, 55, 1, 26, "Output"]
}, Open  ]],
Cell[11435, 345, 243, 5, 59, "Input"],

Cell[CellGroupData[{
Cell[11703, 354, 48, 1, 27, "Input"],
Cell[11754, 357, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11845, 363, 48, 1, 27, "Input"],
Cell[11896, 366, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11988, 372, 48, 1, 27, "Input"],
Cell[12039, 375, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12131, 381, 48, 1, 27, "Input"],
Cell[12182, 384, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12274, 390, 47, 1, 27, "Input"],
Cell[12324, 393, 55, 1, 26, "Output"]
}, Open  ]],
Cell[12394, 397, 84, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[12503, 402, 109, 2, 27, "Input"],
Cell[12615, 406, 54, 1, 26, "Output"]
}, Open  ]],
Cell[12684, 410, 66, 1, 27, "Input"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

